import os
import threading
import time
import tempfile
import uuid
import shutil
from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC
from openpyxl import load_workbook
import random
import tkinter as tk
from tkinter import messagebox, StringVar, IntVar, scrolledtext, filedialog
from urllib.parse import quote
from selenium.webdriver.common.alert import Alert


# Function to generate random codes
def generate_random_code(length=6):
    return ''.join(random.choices('0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ', k=length))

def validate_phone_number(phone):
    """
    Telefon numarasını doğrular ve standart formata çevirir
    Beklenen format: 5356153872 (10 haneli, 5 ile başlayan)
    """
    # Sadece rakamları al
    phone_clean = ''.join(filter(str.isdigit, str(phone)))
    
    # Türkiye telefon numarası formatını kontrol et
    if len(phone_clean) == 10:
        # 10 haneli numara (5xx xxx xxxx formatı)
        if phone_clean.startswith('5'):
            return phone_clean
        else:
            return None
    elif len(phone_clean) == 11:
        # 11 haneli numara (05xx xxx xxxx formatı)
        if phone_clean.startswith('0') and phone_clean[1] == '5':
            return phone_clean[1:]  # Başındaki 0'ı kaldır
        else:
            return None
    elif len(phone_clean) == 12:
        # 12 haneli numara (905xx xxx xxxx formatı)
        if phone_clean.startswith('90') and phone_clean[2] == '5':
            return phone_clean[2:]  # 90'ı kaldır
        else:
            return None
    else:
        return None

picture_video_extensions = ['.jpg', '.jpeg', '.png', '.gif', '.mp4', '.3gp', '.mov']

def process_excel(file_path): 
    wb = load_workbook(file_path)
    ws = wb.active
    
    data = []
    print(f"Excel dosyası açıldı: {file_path}")
    
    for row_idx, row in enumerate(ws.iter_rows(min_row=2, values_only=True), start=2):
        if len(row) < 2:  # En az 2 sütun olmalı
            print(f"Satır {row_idx}: Yetersiz sütun sayısı ({len(row)})")
            continue
        
        durum, telefon = row[:2]
        print(f"Satır {row_idx}: Durum={durum}, Telefon={telefon}")
        
        if durum == 0 or durum == "0":
            # Telefon numarasını temizle (sadece rakamları al)
            telefon = ''.join(filter(str.isdigit, str(telefon)))
            
            # Telefon numarası formatını kontrol et ve düzelt
            if len(telefon) == 10:
                # 10 haneli numara (5xx xxx xxxx formatı)
                if telefon.startswith('5'):
                    # Zaten doğru format
                    data.append((telefon, row_idx))
                    print(f"✅ Numara eklendi: {telefon}")
                else:
                    print(f"⚠️ Geçersiz numara formatı (5 ile başlamalı): {telefon}")
                    continue
            elif len(telefon) == 11:
                # 11 haneli numara (05xx xxx xxxx formatı)
                if telefon.startswith('0') and telefon[1] == '5':
                    telefon = telefon[1:]  # Başındaki 0'ı kaldır
                    data.append((telefon, row_idx))
                    print(f"✅ Numara eklendi: {telefon}")
                else:
                    print(f"⚠️ Geçersiz numara formatı: {telefon}")
                    continue
            elif len(telefon) == 12:
                # 12 haneli numara (905xx xxx xxxx formatı)
                if telefon.startswith('90') and telefon[2] == '5':
                    telefon = telefon[2:]  # 90'ı kaldır
                    data.append((telefon, row_idx))
                    print(f"✅ Numara eklendi: {telefon}")
                else:
                    print(f"⚠️ Geçersiz numara formatı: {telefon}")
                    continue
            else:
                print(f"⚠️ Geçersiz numara uzunluğu: {telefon} ({len(telefon)} hane)")
                continue
        else:
            print(f"⚠️ Durum 0 değil: {durum}")
    
    print(f"Excel dosyasından {len(data)} numara bulundu")
    return data, wb

def update_excel(wb, row_idx, file_path):
    ws = wb.active
    ws.cell(row=row_idx, column=1, value=1)  # Durum sütununu güncelle
    wb.save(file_path) 

def send_message(file_path, data, wb, message_template, log_textbox):
    # Use threading for concurrent execution
    threading.Thread(
        target=send_message_sync,
        args=(file_path, data, wb, message_template, log_textbox)
    ).start()

def wait_for_page_load(driver, timeout=30):
    try:
        WebDriverWait(driver, timeout).until(
            EC.presence_of_element_located((By.TAG_NAME, "body"))
        )
    except Exception as e:
        print(f"An error occurred while waiting for the page to load: {e}")
        raise

def send_message_sync(file_path, data, wb, message_template, log_textbox):
    options = webdriver.ChromeOptions()

    options.add_argument("--disable-notifications")
    options.add_argument("--disable-popup-blocking")
    options.add_argument("--disable-extensions")
    options.add_argument("--disable-infobars")  # Bilgilendirme çubuğunu kaldırır
    options.add_experimental_option("excludeSwitches", ["enable-automation"])  # Otomasyonu gizle
    options.add_experimental_option("useAutomationExtension", False)  # Varsayılan otomasyon uzantısını kaldırır
    
    # Kalıcı Chrome profil yolu oluştur (QR kod bir kez okutulacak)
    user_home = os.path.expanduser("~")
    chrome_profile_dir = os.path.join(user_home, "whatsapp_chrome_profile")
    
    # Profil dizinini oluştur
    if not os.path.exists(chrome_profile_dir):
        os.makedirs(chrome_profile_dir)
    
    options.add_argument(f"--user-data-dir={chrome_profile_dir}")

    driver = webdriver.Chrome(options=options)
    driver.get("https://web.whatsapp.com/")
    driver.maximize_window()
    messagebox.showwarning("ÖNEMLİ", "QR KODU OKUTTUKTAN VE MESAJLAR YÜKLENDİKTEN SONRA 'TAMAM' BASINIZ.")
    driver.implicitly_wait(5)

    atilanlar = []
    for telefon, row_idx in data:
        if telefon not in atilanlar:
            atilanlar.append(telefon)
            try:
                # Telefon numarası formatını kontrol et ve düzelt
                phone_clean = ''.join(filter(str.isdigit, str(telefon)))
                
                # Türkiye ülke kodu (90) ekle - WhatsApp'ın beklediği format
                if len(phone_clean) == 10 and phone_clean.startswith('5'):
                    # 5356153872 formatındaki numara
                    phone_number = f"90{phone_clean}"
                elif len(phone_clean) == 11 and phone_clean.startswith('0') and phone_clean[1] == '5':
                    # 05356153872 formatındaki numara
                    phone_number = f"90{phone_clean[1:]}"
                elif len(phone_clean) == 12 and phone_clean.startswith('90') and phone_clean[2] == '5':
                    # 905356153872 formatındaki numara
                    phone_number = phone_clean
                else:
                    log_textbox.insert(tk.END, f"Hata: Geçersiz telefon numarası formatı: {telefon}\n")
                    continue

                # Mesajı URL için kodlama
                encoded_message = quote(message_template.strip())
                # WhatsApp API URL'si oluşturma
                url = f"https://web.whatsapp.com/send?phone={phone_number}&text={encoded_message}"
                
                log_textbox.insert(tk.END, f"Numara işleniyor: {phone_number} (Orijinal: {telefon})\n")
                log_textbox.see(tk.END)
                
                driver.get(url)
                time.sleep(4)

                wait_for_page_load(driver)
                time.sleep(15)

                # Gönder butonunu bul ve tıkla
                try:
                    send_button = driver.find_element(By.XPATH, "//button[@aria-label='Gönder']")
                    send_button.click()
                    time.sleep(7)  # Gönderilmesi için bekleyin
                    
                    log_textbox.insert(tk.END, f"✅ Mesaj gönderildi: {telefon}\n")
                    # Excel güncellemesi
                    update_excel(wb, row_idx, file_path)
                    
                except Exception as send_error:
                    log_textbox.insert(tk.END, f"⚠️ Gönder butonu bulunamadı: {telefon} - {send_error}\n")
                    # Alternatif gönder butonu arama
                    try:
                        send_button = driver.find_element(By.XPATH, "//span[@data-icon='send']")
                        send_button.click()
                        time.sleep(7)
                        log_textbox.insert(tk.END, f"✅ Mesaj gönderildi (alternatif): {telefon}\n")
                        update_excel(wb, row_idx, file_path)
                    except:
                        log_textbox.insert(tk.END, f"❌ Mesaj gönderilemedi: {telefon}\n")

            except Exception as e:
                log_textbox.insert(tk.END, f"Hata[-]: {telefon} - {e}\n")
                log_textbox.insert(tk.END, f"Diğer numaraya geçiliyor...\n")
                log_textbox.see(tk.END)
                continue
        else:
            continue

    log_textbox.insert(tk.END, "Tüm mesajlar gönderildi ve Excel dosyası güncellendi.\n")
    log_textbox.see(tk.END)
    driver.quit()

def start_process(file_path, message_template, log_textbox):
    data, wb = process_excel(file_path)
    send_message(file_path, data, wb, message_template, log_textbox)

def select_file(file_path_var):
    file_path = filedialog.askopenfilename(filetypes=[("Excel Files", "*.xlsx;*.xls")])
    file_path_var.set(file_path)

def start_gui():
    root = tk.Tk()
    root.title("WhatsApp Mesaj Gönderici - Yass.Coding")
    root.geometry("600x800")  # Smaller window size to reduce empty space
    root.configure(bg='#f8fafc')
    root.resizable(True, True)  # Allow resizing
    
    # Modern light color scheme - Clean and professional
    primary_color = "#3b82f6"  # Modern blue
    secondary_color = "#64748b"  # Slate gray
    accent_color = "#06b6d4"  # Cyan accent
    surface_color = "#ffffff"  # White surface
    card_color = "#ffffff"  # White card background
    text_primary = "#1e293b"  # Dark slate text
    text_secondary = "#64748b"  # Secondary text
    success_color = "#10b981"  # Success green
    warning_color = "#ef4444"  # Warning red
    border_color = "#e2e8f0"  # Light border
    bg_color = "#f8fafc"  # Light background
    
    # Custom styles and effects
    def create_modern_card(parent, title, icon="", bg_color=card_color):
        """Create a modern card with subtle shadow effect"""
        card = tk.Frame(parent, bg=bg_color, relief="flat", bd=1, highlightbackground=border_color, highlightthickness=1)
        
        # Card header with icon and title
        header_frame = tk.Frame(card, bg=bg_color, height=35)
        header_frame.pack(fill=tk.X, padx=12, pady=(12, 0))
        header_frame.pack_propagate(False)
        
        if icon:
            icon_label = tk.Label(header_frame, text=icon, bg=bg_color, fg=primary_color,
                                font=("Segoe UI", 11))
            icon_label.pack(side=tk.LEFT, padx=(0, 8))
        
        title_label = tk.Label(header_frame, text=title, bg=bg_color, fg=text_primary,
                              font=("Segoe UI", 11, "bold"))
        title_label.pack(side=tk.LEFT)
        
        return card
    
    def create_modern_button(parent, text, command, bg_color=primary_color, 
                           fg_color="#ffffff", width=15, height=2, icon=""):
        """Create a modern button with hover effects"""
        button_frame = tk.Frame(parent, bg=bg_color, relief="flat", bd=0)
        
        if icon:
            button_text = f"{icon} {text}"
        else:
            button_text = text
            
        button = tk.Button(button_frame, text=button_text, command=command,
                          bg=bg_color, fg=fg_color, font=("Segoe UI", 9, "bold"),
                          relief="flat", width=width, height=height, cursor="hand2",
                          activebackground=accent_color, activeforeground="#ffffff")
        button.pack(padx=2, pady=2)
        
        return button_frame
    
    def create_modern_entry(parent, variable, placeholder="", width=40):
        """Create a modern entry field"""
        entry_frame = tk.Frame(parent, bg=surface_color, relief="flat", bd=1, 
                              highlightbackground=border_color, highlightthickness=1)
        
        entry = tk.Entry(entry_frame, textvariable=variable, bg=surface_color, fg=text_primary,
                        font=("Segoe UI", 9), relief="flat", insertbackground=text_primary,
                        width=width)
        entry.pack(padx=10, pady=10, fill=tk.X, expand=True)
        
        # Add placeholder effect
        if placeholder:
            entry.insert(0, placeholder)
            entry.config(fg=text_secondary)
            
            def on_focus_in(event):
                if entry.get() == placeholder:
                    entry.delete(0, tk.END)
                    entry.config(fg=text_primary)
            
            def on_focus_out(event):
                if not entry.get():
                    entry.insert(0, placeholder)
                    entry.config(fg=text_secondary)
            
            entry.bind('<FocusIn>', on_focus_in)
            entry.bind('<FocusOut>', on_focus_out)
        
        return entry_frame
    
    # Create main frame - Simple approach to eliminate empty space
    main_container = tk.Frame(root, bg=bg_color)
    main_container.pack(fill=tk.BOTH, expand=True, padx=15, pady=15)
    
    # Header section with modern design
    header_card = create_modern_card(main_container, "", bg_color=bg_color)
    header_card.pack(fill=tk.X, pady=(0, 15))
    
    # Header accent line
    accent_line = tk.Frame(header_card, bg=primary_color, height=3)
    accent_line.pack(fill=tk.X, pady=(0, 15))
    
    # Main title with modern typography
    title_frame = tk.Frame(header_card, bg=bg_color)
    title_frame.pack(fill=tk.X)
    
    main_title = tk.Label(title_frame, text="WhatsApp Mesaj Gönderici", 
                         bg=bg_color, fg=text_primary, 
                         font=("Segoe UI", 18, "bold"))  # Slightly smaller font
    main_title.pack(pady=(0, 4))
    
    # Subtitle with Yass.Coding branding
    subtitle = tk.Label(title_frame, text="Profesyonel Mesaj Otomasyon Aracı", 
                       bg=bg_color, fg=text_secondary, 
                       font=("Segoe UI", 9))  # Smaller font
    subtitle.pack(pady=(0, 8))
    
    # Branding with modern design - Instagram
    branding_frame = tk.Frame(title_frame, bg=bg_color)
    branding_frame.pack()
    
    brand_label = tk.Label(branding_frame, text="Instagram: yass.coding", 
                          bg=bg_color, fg=primary_color, 
                          font=("Segoe UI", 8, "bold"))  # Smaller font
    brand_label.pack()
    
    # Excel File Selection Card
    excel_card = create_modern_card(main_container, "Excel Dosyası", "📊")
    excel_card.pack(fill=tk.X, pady=(0, 10))
    
    # File selection content
    excel_content = tk.Frame(excel_card, bg=card_color)
    excel_content.pack(fill=tk.X, padx=10, pady=(0, 10))
    
    file_path = StringVar()
    file_entry_frame = create_modern_entry(excel_content, file_path, "Excel dosyası seçin...")
    file_entry_frame.pack(side=tk.LEFT, fill=tk.X, expand=True, padx=(0, 8))
    
    select_excel_btn = create_modern_button(excel_content, "Gözat", 
                                          lambda: select_file(file_path), 
                                          bg_color=primary_color, width=8, height=1)
    select_excel_btn.pack(side=tk.RIGHT)
    
    # Message Template Card - Expanded
    message_card = create_modern_card(main_container, "Mesaj Şablonu", "💬")
    message_card.pack(fill=tk.BOTH, expand=True, pady=(0, 10))
    
    # Message content - Expanded
    message_content = tk.Frame(message_card, bg=card_color)
    message_content.pack(fill=tk.BOTH, expand=True, padx=10, pady=(0, 10))
    
    message_textbox = scrolledtext.ScrolledText(message_content, 
                                               width=45, height=10,  # Reduced width and height
                                               bg=surface_color, fg=text_primary, 
                                               font=("Segoe UI", 9),
                                               insertbackground=text_primary,
                                               relief="flat", bd=1,
                                               highlightbackground=border_color, highlightthickness=1)
    message_textbox.pack(fill=tk.BOTH, expand=True, padx=8, pady=8)
    
    # START BUTTON - BEAUTIFUL AND DESIGN-COMPATIBLE
    def on_start():
        # Validate inputs
        excel_file = file_path.get().strip()
        message_text = message_textbox.get("1.0", tk.END).strip()
        
        if not excel_file:
            messagebox.showerror("Hata", "Lütfen Excel dosyası seçin.")
            return
        
        if not message_text:
            messagebox.showerror("Hata", "Lütfen mesaj şablonu girin.")
            return
        
        # Check if Excel file exists
        if not os.path.exists(excel_file):
            messagebox.showerror("Hata", "Seçilen Excel dosyası bulunamadı.")
            return
        
        # Clear previous logs
        log_textbox.delete(1.0, tk.END)
        
        # Add log message to show process is starting
        log_textbox.insert(tk.END, "🚀 Mesaj gönderme işlemi başlatılıyor...\n")
        log_textbox.see(tk.END)
        
        # Start the process
        start_process(excel_file, message_text, log_textbox)
    
    # Create a beautiful and design-compatible start button
    start_button_frame = tk.Frame(main_container, bg=bg_color)
    start_button_frame.pack(fill=tk.X, pady=12)
    
    # Create a modern, beautiful start button
    start_button = tk.Button(start_button_frame, 
                           text="🚀 Başlat", 
                           command=on_start,
                           bg=primary_color,  # Modern blue to match design
                           fg="#ffffff",
                           font=("Segoe UI", 11, "bold"),
                           relief="flat",
                           width=12,  # Reduced width
                           height=2,
                           cursor="hand2",
                           activebackground=accent_color,
                           activeforeground="#ffffff",
                           bd=0,
                           highlightthickness=0)
    start_button.pack(pady=5)
    
    # Add hover effect
    def on_enter(e):
        start_button['bg'] = accent_color
    
    def on_leave(e):
        start_button['bg'] = primary_color
    
    start_button.bind("<Enter>", on_enter)
    start_button.bind("<Leave>", on_leave)
    
    # Log Display Card - Larger and more prominent
    log_card = create_modern_card(main_container, "İşlem Logları", "📋")
    log_card.pack(fill=tk.BOTH, expand=True, pady=(0, 10))
    
    # Log content - Larger for better visibility
    log_content = tk.Frame(log_card, bg=card_color)
    log_content.pack(fill=tk.BOTH, expand=True, padx=10, pady=(0, 10))
    
    log_textbox = scrolledtext.ScrolledText(log_content, 
                                           width=45, height=10,  # Reduced width and height
                                           bg=surface_color, fg=text_primary, 
                                           font=("Consolas", 8),  # Smaller font
                                           insertbackground=text_primary,
                                           relief="flat", bd=1,
                                           highlightbackground=border_color, highlightthickness=1)
    log_textbox.pack(fill=tk.BOTH, expand=True, padx=8, pady=8)
    
    # Footer with modern design
    footer_frame = tk.Frame(main_container, bg=bg_color, height=25)  # Reduced height
    footer_frame.pack(fill=tk.X, pady=(8, 0))
    footer_frame.pack_propagate(False)
    
    footer_label = tk.Label(footer_frame, text="© 2024 Yass.Coding - Tüm hakları saklıdır", 
                           bg=bg_color, fg=text_secondary, 
                           font=("Segoe UI", 7))  # Smaller font
    footer_label.pack(expand=True)
    
    # Add some modern spacing and effects
    for widget in [excel_card, message_card, log_card]:
        widget.configure(relief="flat", bd=1, highlightbackground=border_color, highlightthickness=1)
    
    root.mainloop()
start_gui()
